/************************************************************************
ProcessHelper - A class to manipulate processes on Win32
Copyright (C) 2006 Daniel "Lesco" Schoepe

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
************************************************************************/

#ifndef INC_PROCESS_HELPER_H
#define INC_PROCESS_HELPER_H

#include <windows.h>
#include <vector>
#include <cstdio>
#include "PEFile.h"

using std::vector;

class ProcessHelper;

typedef void (__stdcall *  BP_HANDLER)(ProcessHelper*,CONTEXT&);

class ProcessHelper
{	
public:
	ProcessHelper();
	~ProcessHelper();
	ProcessHelper(HANDLE process);

	void setProcess(HANDLE process);
	HANDLE getProcess();

	DWORD readDword(DWORD addr);
	WORD readWord(DWORD addr);
	BYTE readByte(DWORD addr);
	void readData(DWORD addr,void *buffer,DWORD length);

	void writeDword(DWORD addr,DWORD data);
	void writeWord(DWORD addr,WORD data);
	void writeByte(DWORD addr,BYTE data);
	void writeData(DWORD addr,void *buffer,DWORD length);

	void addBreakpoint(DWORD addr);
	void addBreakpointAndRun(DWORD addr,BP_HANDLER handler,HANDLE thread);
	void removeBreakpoint(DWORD addr);
	void waitForBreakpoint(DWORD addr,HANDLE thread,CONTEXT& ctx);

	DWORD getImageSize(DWORD imageBase);

	void dumpProcess(DWORD imageBase,const char *filename);

	DWORD searchPattern(DWORD start,const char *pattern,DWORD size=0);

	void injectLibrary(char *libname);
	/*
	Error-code as structured as following:
	-If it's positive, it's an errorcode from Windows
	 and FormatMessage is used to format the message
	-If it's negative, it's an own errorcode
	Not a very elegant solution though, but it saves work
	The caller has to free the message buffer using LocalFree
	*/
	static char * formatErrorMessage(int errorccde);
	enum Exception {
		BP_ALREADY_SET		= -1,
		NO_PROCESS_OPENED	= -2,
		INVALID_PARAMETER	= -3
	};

private:
	struct THREAD_DATA;
	struct BP_DATA {
		DWORD addr;
		ProcessHelper* ph;
		HANDLE thread;
		BP_HANDLER handler;
		//this is used by the waiting thread from the
		//list of still running threads
		vector<THREAD_DATA> *bpThreads;
		
	};
	struct THREAD_DATA {
		HANDLE handle;
		DWORD tid;
		BP_DATA *data;
	};
	struct BREAKPOINT {
		WORD oldBytes;
		DWORD addr;
	};
	static DWORD __stdcall waitForBpProc(BP_DATA *);
	bool processOpened;
	HANDLE process;
	vector<BREAKPOINT> breakpoints;
	vector<THREAD_DATA> runningThreads;
};

#endif //INC_PROCESS_HELPER_H